import React, { Component } from 'react';
import ReactDOM from 'react-dom';

export default class LoginNav extends Component {

  state = {
    showDropdown: false
  }

  componentWillMount() {
    document.addEventListener('click', this.handleClickOutside, false);
  }

  componentWillUnmount() {
    document.removeEventListener('click', this.handleClickOutside, false);
  }

  handleClickOutside = (e) => {
    if(!ReactDOM.findDOMNode(this).contains(e.target)) {
      this.hideDropDown();
    }
  }

  onClickSettings = (e) => {
    e.preventDefault();
    this.props.history.push('/settings');
  }

  onClickLogin = (e) => {
    e.preventDefault();
    this.props.history.push('/login');
  }

  toggleShowDropdown = () => {
    this.setState({showDropdown: !this.state.showDropdown});
  }

  hideDropDown = () => {
    this.setState({showDropdown: false});
  }

  render() {

    const {isAuthenticated, currentUser, onLogout} = this.props;

    if (isAuthenticated) {
      return (

        <li className={`nav-item dropdown navs ${this.state.showDropdown?'show':''}`}>
          <a className="nav-link dropdown-toggle" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded={this.state.showDropdown} onClick={this.toggleShowDropdown} onBlur={this.hideDropDown}>
          { currentUser.get('username') }
          &nbsp;<span className="caret"></span>
          </a>
          <ul className={`dropdown-menu ${this.state.showDropdown?'show':''}`} aria-labelledby="navbarDropdown">
            <li><a className="user-dropdown" href="#settings" onClick={this.onClickSettings}>Paramètres</a></li>
            <li><a className="user-dropdown" href="#logout" onClick={onLogout}>Se déconnecter</a></li>
          </ul>
        </li>
      );
    } else {
      return (
          <li>
          <a className="navs" onClick={this.onClickLogin} href="/login">Se connecter</a>
          </li>
      );
    }
  }
}
