import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { formatTimestamp } from '../utils';
import SlateEditor from './SlateEditor';
import './Note.css';

class Note extends Component {

  onClickDelete = (e) => {
    e.preventDefault();
    e.stopPropagation();

    this.props.onDelete();
  }

  onClickButton = (e) => {

    const plain = this.refs.editor.asPlain();
    const raw = this.refs.editor.asRaw();
    const html = this.refs.editor.asHtml();
    const categories = this.refs.editor.asCategories();
    // const marginComment = this.marginComment.value;

    const data = {
      plain,
      raw,
      html,
      categories,
      // marginComment
    }

    this.props.onSave(this.props.note, data);
  }

  onClickClose = (e) => {
    e.preventDefault();
    e.stopPropagation();

    this.props.onClose();
  }

  renderNoteContent() {
    if (this.props.isEditing) {
      return (
        <div className="note-content w-100 pl-2 pt-2">
          <SlateEditor ref="editor"
            onButtonClick={ this.onClickButton }
            note={ this.props.note }
            annotationCategories={ this.props.annotationCategories } />
        </div>
      )
    }

    return (
      <div className="note-content w-100 pl-2 pt-2" dangerouslySetInnerHTML={{ __html: this.props.note.html }} />
    )
  }

  // renderNoteMarginComment() {
  //   if (this.props.isEditing) {
  //     return (
  //       <div className="row">
  //       <div className="note-margin-comment w-25 mt-3">
  //         <input type="text" className="form-control"
  //           name="margin"
  //           componentClass="textarea"
  //           placeholder="Espace pour un commentaire de marge"
  //           defaultValue={ this.props.note.marginComment }
  //           // inputRef={ ref => { this.marginComment = ref; } } />
  //           ref={(marginComment) => { this.marginComment = marginComment; }} />
  //       </div>
  //       </div>
  //     )
  //   }

    // return (
    //   <div className="note-margin-comment w-25 mt-5">
    //     <small className="text-muted">{ this.props.note.marginComment }</small>
    //   </div>
    // )
  // }

  renderNoteRight() {
    if (this.props.isEditing) {
      return (
        <a onClick={this.onClickClose}>
          <span className="material-icons pl-2">close</span>
        </a>
      );
    }

    return (
      <a onClick={this.onClickDelete}>
        <span className="material-icons delete-icon pl-2">delete</span>
      </a>
    )
  }

  render() {
    return (
    <div id={"note-" + this.props.note._id} className="note text-sm mr-5 pt-1"
    onClick={ this.props.onClick }>
      <div className="mr-5">
        <small className="start text-warning pt-2">{ formatTimestamp(this.props.note.startedAt) }</small>
        <small className="finish text-warning pb-2">{ formatTimestamp(this.props.note.finishedAt) }</small>
      </div>
        { this.renderNoteContent() }
        {/* { this.renderNoteMarginComment() } */}
        <div className="float-right">
        { this.renderNoteRight() }
        </div>
    </div>
    );
  };
}

Note.propTypes = {
  note: PropTypes.object.isRequired,
};

export default Note;
