class APIClient {
  constructor(baseURL) {
    this.baseURL = baseURL;
  }

  setStore = (store) => {
    this.store = store;
  }

  createRequest = (method, uri, data, headers) => {

    headers = headers || new Headers();
    if(method !== 'HEAD') {
      headers.append("Content-Type", "application/json");
    } else {
      headers.append("Content-Type", "text/plain");
    }


    var options = {
      method: method,
      headers: headers,
    };

    if (data) {
      options.body = JSON.stringify(data);
    }

    // TODO : use URL-module to build URL
    return new Request(this.baseURL + uri, options);
  }

  getToken = () => {
    const state = this.store.getState();
    return state['token'];
  }

  hasToken = () => {
    const token = this.getToken();

    return token !== null && token !== '';
  }

  createAuthorizedRequest = (method, uri, data) => {

    var headers = new Headers(),
        token = this.getToken() || '';
    headers.append("Authorization", "JWT " + token);

    return this.createRequest(method, uri, data, headers);
  }

  request = (method, uri, data) => {
    var req = this.hasToken() ? this.createAuthorizedRequest(method, uri, data) : this.createRequest(method, uri, data);
    return this.fetch(req, { credentials: 'include' });
  }

  get = (uri, data) => {
    return this.request('GET', uri, data);
  }

  post = (uri, data) => {
    return this.request('POST', uri, data);
  }

  put = (uri, data) => {
    return this.request('PUT', uri, data);
  }

  fetch = (req) => {
    return new Promise((resolve, reject) => {
      fetch(req)
        .then((response) => {
          if (response.ok) {
            let resJsonPromise;
            if(response.status === 204) {
              resJsonPromise = Promise.resolve({});
            } else {
              resJsonPromise = response.text().then(data => {
                if(data.length > 0) {
                  return JSON.parse(data);
                } else {
                  return {};
                }
              });
            }
            return resJsonPromise.then(data => resolve(data));

          } else {
            return response.json().then(data => reject(data));
          }
        })
        .catch((error) => {
          reject({error});
        });
    });
  }
}

export default APIClient
