import React, { Component } from 'react';
import { connect } from 'react-redux';
import { Panel, ListGroup, ListGroupItem } from 'react-bootstrap';
import _ from 'lodash';
import '../App.css';

class SessionSummary extends Component {
  render() {
    return (
      <Panel>
        <ListGroup>
          {this.props.notes.map((note) =>
            <ListGroupItem key={note.get('_id')}>
              <a href={'#note-' + note.get('_id')}>
                <span className="text-muted">{note.startedAt} → {note.finishedAt}</span>
                <span className="pull-right">{_.words(note.plain).length} words</span>
              </a>
            </ListGroupItem>
          )}
        </ListGroup>
      </Panel>
    );
  }
}

function mapStateToProps(state, props) {
  return props;
}

export default connect(mapStateToProps)(SessionSummary);
