import rootReducer from '../reducers';
import rootSaga from '../sagas';
import { loadSessions } from '../actions/sessionsActions';
import { compose, createStore, applyMiddleware } from 'redux';
import { routerMiddleware } from 'react-router-redux';
import handleTransitions from 'redux-history-transitions';
import createSagaMiddleware from 'redux-saga'
import Immutable from 'immutable';
import { offline } from 'redux-offline';
import offlineDefaultConfig from 'redux-offline/lib/defaults';
import localForage from 'localforage';
import immutableTransform from 'redux-persist-transform-immutable'
import NoteRecord from './noteRecord'
import APIClient from '../APIClient';
import config from '../config';

const token = localStorage.getItem('token');
const currentUser = localStorage.getItem('currentUser');

const defaultState = {
//  currentSession: null,
  sessions: Immutable.List([]),
  notes: Immutable.List([]),
  isAuthenticated: token !== null,
  currentUser: currentUser ? JSON.parse(currentUser) : null,
  token: token,
  login: {
    loading: false,
    success: false,
    error: false,
  }
};

const immutableTransformConfig = {
    records: [NoteRecord],
    whitelist: ['sessions', 'notes']
}

const offlineConfig = {
  ...offlineDefaultConfig,
  persistOptions: {
    storage: localForage,
    transforms: [immutableTransform(immutableTransformConfig)]
  },
  detectNetwork: callback => callback(true),
}

//const storeInitialState = Immutable.Map(defaultState);
//const storeInitialState = new Map(defaultState);
const storeInitialState = defaultState;

export default (history, initialState = storeInitialState) => {

  const router = routerMiddleware(history);
  const saga = createSagaMiddleware();
  const transitions = handleTransitions(history);

  const store = offline(offlineConfig)(createStore)(rootReducer, initialState, compose(
    applyMiddleware(router, saga),
    transitions
  ));

  const context = {
      client: new APIClient(config.apiRootUrl, store)
  }

  saga.run(rootSaga, context);

  //store.dispatch(loadSessions());

  return store;
};
