//import uuidV1 from 'uuid/v1';

import * as types from '../constants/actionTypes';

export const createSession = (sessionId) => {

  //const sessionId = uuidV1();
  const newSession = {
      _id: sessionId,
      ext_id: sessionId,
      date: new Date(),
      title: '',
      description: '',
  };

  return {
    type: types.CREATE_SESSION,
    session: newSession,
    meta: {
      offline: {
        effect: {
          url: "http://localhost:8000/api/notes/sessions/",
          body: JSON.stringify(newSession), method: 'POST',
          headers: {
            Authorization: "JWT eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyX2lkIjoyLCJlbWFpbCI6IiIsInVzZXJuYW1lIjoieW1oIiwiZXhwIjoxNDk3NjU2MjY5fQ.qrwbC4oRqvWNOp8x_8yZRJJowVVoFEpjy1uLhiERTTI"
          }
        },
        commit: { type: types.CREATE_SESSION_ASYNC },
        rollback: { type: 'NoOp'}
      }
    }
  };
}

export const updateSession = (session, values) => {
  return {
    type: types.UPDATE_SESSION,
    session: session,
    values: values,
  };
}

export const loadSessions = () => {
  return {
    type: types.LOAD_SESSIONS
  }
}
