import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
// import logo from './logo.svg';
import { Navbar, Nav, NavItem, NavDropdown, MenuItem } from 'react-bootstrap';
import * as authActions from '../actions/authActions';

class AppNavbar extends Component {

  onClickHome = (e) => {
    e.preventDefault();
    this.props.history.push('/');
  }

  onClickSessions = (e) => {
    e.preventDefault();
    this.props.history.push('/sessions');
  }

  onClickLogin = (e) => {
    e.preventDefault();
    this.props.history.push('/login');
  }

  onClickSettings = (e) => {
    e.preventDefault();
    this.props.history.push('/settings');
  }

  onClickLogout = (e) => {
    e.preventDefault();
    this.props.authActions.logout();
  }

  renderLogin() {

    if (this.props.currentUser) {
      return (
        <NavDropdown title={ this.props.currentUser.username } id="user-dropdown">
          <MenuItem onClick={this.onClickSettings}>Settings</MenuItem>
          <MenuItem onClick={this.onClickLogout}>Logout</MenuItem>
        </NavDropdown>
      );
    }

    return (
      <NavItem onClick={this.onClickLogin} href="/login">Login</NavItem>
    );
  }

  render() {
    return (
      <Navbar fluid inverse fixedTop>
        <Navbar.Header>
          <Navbar.Brand>
            <a onClick={this.onClickHome} href="/">IRI Notes</a>
          </Navbar.Brand>
          <Navbar.Toggle />
        </Navbar.Header>
        <Navbar.Collapse>
          <Nav>
            <NavItem onClick={this.onClickSessions} href="/sessions">Sessions</NavItem>
          </Nav>
          <Nav pullRight>
            {this.renderLogin()}
          </Nav>
        </Navbar.Collapse>
      </Navbar>
    );
  }
}

AppNavbar.propTypes = {
  isAuthenticated: PropTypes.bool.isRequired
};

function mapStateToProps(state, props) {
  return {
    isAuthenticated: state.get('isAuthenticated'),
    currentUser: state.get('currentUser'),
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(AppNavbar);
