import Immutable from 'immutable';
import * as types from '../constants/actionTypes';

// export const currentSession = (state = null, action) => {
//   switch (action.type) {
//     case types.CREATE_SESSION:
//       return action.session;
//     default:
//       return state;
//   }
// };

export const sessions = (state = Immutable.List([]), action) => {
  switch (action.type) {
    case types.CREATE_SESSION:
      return state.push(action.session);
    case types.UPDATE_SESSION:
      const sessionToUpdate = state.find(session => session === action.session);
      const sessionIndex = state.indexOf(action.session);
      if (sessionIndex === -1) {
        return state;
      }
      const updatedSession = Object.assign({}, sessionToUpdate, action.values);
      return state.set(sessionIndex, updatedSession);
    case types.LOAD_SESSIONS:
      return action.sessions;
    default:
      return state;
  }
};
