
import { lastSync, isSynchronizing } from '../syncReducer';
import * as types from '../../constants/actionTypes';


describe('misc reducer lastSync', () => {

  it('should return the initial state', () => {
    expect(
      lastSync(undefined, {})
    ).toEqual(0)
  });

  it('should handle SYNC_SET_LAST_SYNC true', () => {
    expect(
      lastSync(false, {
        type: types.SYNC_SET_LAST_SYNC,
        value: 10
      })
    ).toEqual(10)
  });

  it('should handle AUTH_LOGOUT false', () => {
    expect(
      lastSync(true, {
        type: types.AUTH_LOGOUT
      })
    ).toEqual(0)
  });

});



describe('misc reducer isSynchronizing', () => {

  it('should return the initial state', () => {
    expect(
      isSynchronizing(undefined, {})
    ).toEqual(false)
  });

  it('should handle SYNC_START_SYNC', () => {
    expect(
      isSynchronizing(false, {
        type: types.SYNC_START_SYNC
      })
    ).toEqual(true)
  });

  it('should handle SYNC_END_SYNC', () => {
    expect(
      isSynchronizing(true, {
        type: types.SYNC_END_SYNC
      })
    ).toEqual(false)
  });

});
