import React, { Component } from 'react';
import ReactDOM from 'react-dom';

export default class LoginNav extends Component {

  state = {
    showDropdown: false
  }

  componentWillMount() {
    document.addEventListener('click', this.handleClickOutside, false);
  }

  componentWillUnmount() {
    document.removeEventListener('click', this.handleClickOutside, false);
  }

  handleClickOutside = (e) => {
    e.preventDefault();
    const currentNode = ReactDOM.findDOMNode(this);
    if(!currentNode.contains(e.target)) {
      this.hideDropDown();
    }
  }

  onClickSettings = (e) => {
    e.preventDefault();
    this.props.history.push('/settings');
  }

  onClickLogin = (e) => {
    e.preventDefault();
    this.props.history.push('/login');
  }

  toggleShowDropdown = () => {
    this.setState({showDropdown: !this.state.showDropdown});
  }

  hideDropDown = () => {
    this.setState({showDropdown: false});
  }

  render() {

    const {isAuthenticated, currentUser, onLogout} = this.props;

    if (isAuthenticated) {
      return (

        <li className={`nav-item dropdown ${this.state.showDropdown?'show':''}`}>
          <a className="nav-link dropdown-toggle username font-weight-bold" id="navbarDropdown" role="button" aria-haspopup="true" aria-expanded={this.state.showDropdown} onClick={this.toggleShowDropdown} onBlur={this.hideDropDown}>
          { currentUser.username }
          &nbsp;<span className="caret"></span>
          </a>
          <div className={`dropdown-menu dropdown-menu-right bg-primary border-0 ${this.state.showDropdown?'show':''}`} aria-labelledby="navbarDropdown">
            <a className="dropdown-item bg-primary text-secondary font-weight-bold" onClick={this.onClickSettings}>Paramètres</a>
            <a className="dropdown-item bg-primary text-secondary font-weight-bold" onClick={onLogout}>Se déconnecter</a>
          </div>
        </li>
      );
    } else {
      return (
          <li className="nav-item">
          <a className="nav-link" onClick={this.onClickLogin} href="/login">Se connecter</a>
          </li>
      );
    }
  }
}
