import React, { Component } from 'react';
import { connect } from 'react-redux';
import Note from './Note';
import Navbar from './Navbar';
import SessionForm from './SessionForm';
import { getSession, getSessionNotes } from '../selectors/coreSelectors';
import './ReadOnlySession.css';



class ReadOnlySession extends Component {

  onClickSession = (e) => {
    e.preventDefault();
    this.props.history.push('/sessions/' +  this.props.match.params.id)
  }

  render() {

    return (
          <div>
            <Navbar history={this.props.history} />
            <div className="ml-4">
              <SessionForm session={this.props.currentSession} />
              <a className="text-primary font-weight-bold float-left" onClick={this.onClickSession} href="/sessions">Atteindre la session</a>
              <div>
                {this.props.notes.map((note) =>
                  <Note
                    note={ note }
                    key={ note._id}
                    annotationCategories={this.props.annotationCategories} />
                )}
              </div>
            </div>
          </div>
    );
  }
};


function mapStateToProps(state, props) {

  const sessionId = props.match.params.id;

  const currentSession = getSession(sessionId, state);
  const currentNotes = getSessionNotes(sessionId, state);

  return {
    currentSession,
    notes: currentNotes,
  };
}

export default connect(mapStateToProps)(ReadOnlySession);


