import uuid

from concurrency.fields import AutoIncVersionField
from django.conf import settings
from django.core.exceptions import ValidationError
from django.db import models
from django.utils.translation import ugettext_lazy as _

from .managers import MetacategoryManager, ProtocolManager

# Create your models here.

class Protocol(models.Model):
    ext_id = models.UUIDField(
        unique=True, default=uuid.uuid4, verbose_name=_('Model|ext_id'))
    owner = models.CharField(max_length=512, verbose_name=_('Protocol|owner'))
    app = models.ForeignKey(
        settings.AUTH_USER_MODEL,
        on_delete=models.CASCADE,
        null=True,
        blank=True
    )

    def last_revision(self):
        return self.revisions.first()

    objects = ProtocolManager()


class ProtocolRevision(models.Model):
    ext_id = models.UUIDField(
        unique=True, default=uuid.uuid4, verbose_name=_('Model|ext_id'))
    protocol = models.ForeignKey(Protocol, on_delete=models.CASCADE,
                                 related_name="revisions", verbose_name=_('ProtocolRevision|protocol'))
    version = AutoIncVersionField(verbose_name=_('Model|version'), db_index=True)
    title = models.CharField(max_length=512, null=True,
                             blank=True, verbose_name=_('ProtocolRevision|title'))
    description = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('ProtocolRevision|description')
    )
    metacategories = models.ManyToManyField('protocols.MetacategoryRevision', related_name="protocols")

    class Meta:
        ordering = ['-version',]

class Metacategory(models.Model):

    objects = MetacategoryManager()

    ext_id = models.UUIDField(
        unique=True, default=uuid.uuid4, verbose_name=_('Model|ext_id'))
    app = models.ForeignKey(
        settings.AUTH_USER_MODEL,
        on_delete=models.SET_NULL,
        null=True,
        blank=True
    )
    label = models.CharField(max_length=512, verbose_name=_('Metacategory|label'))
    title = models.CharField(max_length=512, verbose_name=_('Metacategory|title'))
    description = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Metacategory|description')
    )
    color = models.CharField(max_length=18, verbose_name=_('Metacategory|color'))
    has_comment = models.BooleanField()
    is_default = models.BooleanField()

    def last_revision(self):
        return self.revisions.first()



class MetacategoryRevision(models.Model):
    ext_id = models.UUIDField(
        unique=True, default=uuid.uuid4, verbose_name=_('Model|ext_id'))
    version = AutoIncVersionField(verbose_name=_('Model|version'), db_index=True)
    # protocol = models.ForeignKey(ProtocolRevision, on_delete=models.CASCADE)
    base = models.ForeignKey(Metacategory, on_delete=models.CASCADE,
                             related_name="revisions", verbose_name=_('MetacategoryRevision|base'))
    label = models.CharField(max_length=512, verbose_name=_('Metacategory|label'))
    title = models.CharField(max_length=512, verbose_name=_('Metacategory|title'))
    description = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Metacategory|description')
    )
    color = models.CharField(max_length=18, verbose_name=_('Metacategory|color'))
    has_comment = models.BooleanField()

    class Meta:
        ordering = ['-version',]
