import { put, take, all } from 'redux-saga/effects'
import * as types from '../constants/actionTypes';

function* watchCreateGroup(context) {
  while (true) {
    const { group } = yield take(types.GROUP_CREATE_ASYNC);
    const client = context.client;
    try {
      const response = yield client.post('/api/auth/group/', group);
      yield put({ type: types.GROUP_CREATE_SUCCESS, group: response });
    } catch (e) {
      yield put({ type: types.GROUP_CREATE_ERROR, error: e });
    }
  }
}

function* watchCreateGroupAndUpdateSession(context) {
  while (true) {
    const { session, group } = yield take(types.GROUP_CREATE_AND_UPDATE_ASYNC);
    const client = context.client;
    try {
      const response = yield client.post('/api/auth/group/', group);

      const actions = [
        {
          type: types.GROUP_CREATE_SUCCESS,
          group: response
        },
        {
          type: types.UPDATE_SESSION,
          session: session,
          values: { group: response },
        }
      ];

      yield all(actions.map(action => put(action)));

    } catch (e) {
      yield put({ type: types.GROUP_CREATE_ERROR, error: e });
    }
  }
}

function* watchLoadGroups(context) {
  const client = context.client;
  while (true) {
    yield take(types.GROUP_LOAD_ASYNC);
    try {
      const response = yield client.get('/api/auth/group/');
      yield put({ type: types.GROUP_LOAD_SUCCESS, groups: response });
    } catch (e) {
      yield put({ type: types.GROUP_LOAD_ERROR, error: e });
    }
  }
}

export default function* rootSaga(context) {
  yield all([
    watchCreateGroup(context),
    watchCreateGroupAndUpdateSession(context),
    watchLoadGroups(context),
  ])
}
