import React from 'react';

import PropTypes from 'prop-types';
import Immutable from 'immutable';

import { ListGroup, ListGroupItem, Alert } from 'react-bootstrap';

import Note from './Note';

const NotesList = ({notes}) => {

  if (notes.size === 0) {
    return (
      <Alert bsStyle="warning">No notes yet. Add notes with the textarea below.</Alert>
    );
  }

  return (
    <ListGroup>
      {notes.map((note) =>
        <ListGroupItem key={note.id}><Note note={note} /></ListGroupItem>
      )}
    </ListGroup>
  );
};

NotesList.propTypes = {
  notes: PropTypes.instanceOf(Immutable.List).isRequired
};

export default NotesList;
