import Note from '../../store/noteRecord';

import WebAnnotationSerializer from '../WebAnnotationSerializer';

it('serializes as expected', () => {

  const category = {
    "key": "keyword",
    "name": "Mot-clé",
    "color": "#2ECC71",
    "text": "Foo",
    "selection": {
      "start": 0,
      "end": 10,
    },
  };

  const comment = {
    "key": "comment",
    "name": "Commentaire",
    "color": "#3498DB",
    "hasComment": true,
    "comment": "Bar",
    "text": "Baz",
    "selection": {
      "start": 0,
      "end": 10,
    },
  }

  const note = new Note({
    _id: '123456',
    session: '9876543',

    plain: 'Foo',
    raw: {},
    html: '',

    startedAt: '',
    finishedAt: '',

    categories: [ category, comment ],

    marginComment: ''
  })

  const actual = WebAnnotationSerializer.serialize(note);

  const expected = [
    {
      "@context": "http://www.w3.org/ns/anno.jsonld",
      "type": "Annotation",
      "id": 0,
      "target": {
        "source": "/session/9876543/notes/123456",
        "selector": [
          {
            "type": "TextQuoteSelector",
            "exact": "Foo"
          },
          {
            "type": "TextPositionSelector",
            "start": 0,
            "end": 10
          }
        ]
      }
    },
    {
      "@context": "http://www.w3.org/ns/anno.jsonld",
      "type": "Annotation",
      "id": 1,
      "body": {
        "type": "TextualBody",
        "value": "Bar",
        "format": "text/plain"
      },
      "target": {
        "source": "/session/9876543/notes/123456",
        "selector": [
          {
            "type": "TextQuoteSelector",
            "exact": "Baz"
          },
          {
            "type": "TextPositionSelector",
            "start": 0,
            "end": 10
          }
        ]
      }
    }
  ];

  // console.log(JSON.stringify(actual, null, 2));

  expect(actual).toMatchObject(expected);
});
