"""
Permissions for core objects
"""
import logging

from rest_framework.permissions import IsAuthenticated

from notes.models import Session

logger = logging.getLogger(__name__)

class SessionPermission(IsAuthenticated):
    """
    Pemissions for sessions
    """

    def has_object_permission(self, request, view, obj):
        return request.user == obj.owner


class NotePermission(IsAuthenticated):
    """
    Permissions for notes
    """

    def has_permission(self, request, view):
        """
        Return `True` if permission is granted, `False` otherwise.
        """
        is_authenticated = super().has_permission(request, view)
        if not is_authenticated:
            return False
        session_ext_id = view.kwargs.get('session_ext_id')
        if is_authenticated and session_ext_id:
            return Session.objects.filter(ext_id=session_ext_id, owner=request.user).exists()
        else:
            return True

