"""
irinotes core module
"""
from django.conf import settings
from django.db import models
from django.utils.translation import ugettext_lazy as _

from .base import Model


class Session(Model):
    class Meta:
        verbose_name = _('Session')
        verbose_name_plural = _('Sessions')

    owner = models.ForeignKey(
        settings.AUTH_USER_MODEL,
        on_delete=models.CASCADE,
    )
    title = models.TextField(null=True, blank=True, verbose_name=_('Session|title'))
    description = models.TextField(null=True, blank=True, verbose_name=_('Session|description'))
    protocol = models.TextField(null=True, blank=True, verbose_name=_('Session|protocol'))

class Note(Model):
    class Meta:
        verbose_name = _('Note')
        verbose_name_plural = _('Notes')
        ordering = ["tc_start"]

    tc_start = models.DateTimeField(verbose_name=_('Note|tc_start'))
    tc_end = models.DateTimeField(verbose_name=_('Note|tc_end'))
    session = models.ForeignKey(Session, on_delete=models.CASCADE, verbose_name=_('Note|session'))
    text_plain = models.TextField(null=True, blank=True, verbose_name=_('Note|text_plain'))
    text_html = models.TextField(null=True, blank=True, verbose_name=_('Note|text_html'))
    text_raw = models.TextField(null=True, blank=True, verbose_name=_('Note|text_raw'))
    margin_note = models.TextField(null=True, blank=True, verbose_name=_('Note|margin_note'))
    categorization = models.TextField(null=True, blank=True, verbose_name=_('Note|categorization'))

