import rootReducer from '../reducers';
import { createStore, applyMiddleware } from 'redux';
import { routerMiddleware } from 'react-router-redux';
import Immutable from 'immutable';

const loadState = () => {
  try {
    const serializedState = localStorage.getItem('state');
    if (!serializedState) {
      return {};
    }
    return JSON.parse(serializedState);
  } catch (err) {
    return {};
  }
}

const saveState = (state) => {
  try {
    localStorage.setItem('state', JSON.stringify(state));
  } catch (err) {}
}

const savedState = loadState();

const defaultState = {
  currentSession: null,
  sessions: Immutable.List(savedState.sessions || []),
  notes: Immutable.List(savedState.notes || []),
  isAuthenticated: false,
};

const storeInitialState = Immutable.Map(defaultState);

export default (history, initialState = storeInitialState) => {

  const middleware = routerMiddleware(history);
  const store = createStore(rootReducer, initialState, applyMiddleware(middleware));

  store.subscribe(() => {
    const state = store.getState().toJSON();
    const stateToPersist = {
      sessions: state.sessions,
      notes: state.notes,
    };

    saveState(stateToPersist);
  });

  return store;
};
