# Generated by Django 2.0.7 on 2018-07-18 15:23

import concurrency.fields
from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0009_alter_user_last_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'User',
                'verbose_name_plural': 'Users',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='GroupProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(blank=True, null=True)),
                ('protocol', models.CharField(blank=True, max_length=512, null=True)),
                ('group', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='profile', to='auth.Group')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('owner_personal', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='personal_group', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'GroupProfile',
                'verbose_name_plural': 'GroupProfiles',
            },
        ),
        migrations.CreateModel(
            name='Note',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='Model|created')),
                ('updated', models.DateTimeField(auto_now=True, db_index=True, verbose_name='Model|updated')),
                ('ext_id', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='Model|ext_id')),
                ('version', concurrency.fields.AutoIncVersionField(default=0, help_text='record revision number', verbose_name='Model|version')),
                ('tc_start', models.DateTimeField(verbose_name='Note|tc_start')),
                ('tc_end', models.DateTimeField(verbose_name='Note|tc_end')),
                ('plain', models.TextField(blank=True, null=True, verbose_name='Note|plain')),
                ('html', models.TextField(blank=True, null=True, verbose_name='Note|html')),
                ('raw', models.TextField(blank=True, null=True, verbose_name='Note|raw')),
                ('margin_note', models.TextField(blank=True, null=True, verbose_name='Note|margin_note')),
                ('categorization', models.TextField(blank=True, null=True, verbose_name='Note|categorization')),
            ],
            options={
                'verbose_name': 'Note',
                'verbose_name_plural': 'Notes',
                'ordering': ['tc_start'],
            },
        ),
        migrations.CreateModel(
            name='Session',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='Model|created')),
                ('updated', models.DateTimeField(auto_now=True, db_index=True, verbose_name='Model|updated')),
                ('ext_id', models.UUIDField(default=uuid.uuid4, unique=True, verbose_name='Model|ext_id')),
                ('version', concurrency.fields.AutoIncVersionField(default=0, help_text='record revision number', verbose_name='Model|version')),
                ('date', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Session|date')),
                ('title', models.TextField(blank=True, null=True, verbose_name='Session|title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Session|description')),
                ('protocol', models.TextField(blank=True, null=True, verbose_name='Session|protocol')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='auth.Group', verbose_name='Session|group')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Session',
                'verbose_name_plural': 'Sessions',
            },
        ),
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('default_group', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='auth.Group', verbose_name='UserProfile|default_group')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='profile', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'UserProfile',
                'verbose_name_plural': 'UserProfiles',
            },
        ),
        migrations.AddField(
            model_name='note',
            name='session',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notes', to='notes.Session', verbose_name='Note|session'),
        ),
    ]
