import {
  getLastSync,
  isSynchronizing,
  isSynchronized
} from '../syncSelectors';

import { ActionEnum } from '../../constants';

describe('Sync selector test', () => {

  test('getLastSync', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: '',
        isAuthenticated: false,
        clientId: null,
        lastSync: 110,
        currentUser: null,
        currentGroup: null
      },
    };

    expect(getLastSync(inputState)).toBe(110);
  });

  test('getLastSyncAbsent', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: '',
        isAuthenticated: false,
        clientId: null,
        currentUser: null,
        currentGroup: null
      },
    };

    expect(getLastSync(inputState)).toBe(0);
  });


  test('getLastSyncAuthStatusAbsent', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
    };

    expect(getLastSync(inputState)).toBe(0);
  });

  test('isSynchronizingFalse', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: '',
        isAuthenticated: false,
        clientId: null,
        lastSync: 110,
        currentUser: null,
        currentGroup: null
      },
    };

    expect(isSynchronizing(inputState)).toBe(false);
  });


  test('isSynchronizingTrue', ()  => {
    const inputState = {
      status: {
        isSynchronizing: true,
        online: false
      },
      authStatus: {
        token: '',
        isAuthenticated: false,
        clientId: null,
        lastSync: 110,
        currentUser: null,
        currentGroup: null
      },
    };

    expect(isSynchronizing(inputState)).toBe(true);
  });

  test('isSynchronizedEmpty', ()  => {
    const inputState = {
      status: {
        isSynchronizing: true,
        online: false
      },
      authStatus: {
        token: '',
        isAuthenticated: false,
        clientId: null,
        lastSync: 110,
        currentUser: null,
        currentGroup: null
      },
      notes: [],
      sessions: []
    };

    expect(isSynchronized(inputState)).toBe(true);
  });


  test('isSynchronizedOk', ()  => {
    const inputState = {
      status: {
        isSynchronizing: true,
        online: false
      },
      authStatus: {
        token: '',
        isAuthenticated: false,
        clientId: null,
        lastSync: 110,
        currentUser: null,
        currentGroup: null
      },
      notes: [ { title: 'note1', action: ActionEnum.NONE }, { title: 'note2', action: ActionEnum.NONE }, { title: 'note3', action: ActionEnum.NONE } ],
      sessions: [ { title: 'session1', action: ActionEnum.NONE }, { title: 'session2', action: ActionEnum.NONE }, { title: 'session3', action: ActionEnum.NONE } ]
    };

    expect(isSynchronized(inputState)).toBe(true);
  });


  test('isSynchronizedKo', ()  => {
    const inputState = {
      status: {
        isSynchronizing: true,
        online: false
      },
      authStatus: {
        token: '',
        isAuthenticated: false,
        clientId: null,
        lastSync: 110,
        currentUser: null,
        currentGroup: null
      },
      notes: [ { title: 'note1', action: ActionEnum.NONE }, { title: 'note2', action: ActionEnum.UPDATED }, { title: 'note3', action: ActionEnum.NONE } ],
      sessions: [ { title: 'session1', action: ActionEnum.NONE }, { title: 'session2', action: ActionEnum.DELETED }, { title: 'session3', action: ActionEnum.NONE } ]
    };

    expect(isSynchronized(inputState)).toBe(false);
  });


  test('isSynchronizedJustOne', ()  => {
    const inputState = {
      status: {
        isSynchronizing: true,
        online: false
      },
      authStatus: {
        token: '',
        isAuthenticated: false,
        clientId: null,
        lastSync: 110,
        currentUser: null,
        currentGroup: null
      },
      notes: [ { title: 'note1', action: ActionEnum.NONE }, { title: 'note2', action: ActionEnum.UPDATED }, { title: 'note3', action: ActionEnum.NONE } ],
      sessions: [ { title: 'session1', action: ActionEnum.NONE }, { title: 'session2', action: ActionEnum.NONE }, { title: 'session3', action: ActionEnum.NONE } ]
    };

    expect(isSynchronized(inputState)).toBe(false);
  });

})
