import React, { Component } from 'react';
import moment from 'moment';

class Clock extends Component {

  state = {
    time: moment().format('H:mm:ss'),
    intervalID: null
  }

  componentDidMount() {
    const intervalID = setInterval(() => {
      const time = moment().format('H:mm:ss');
      this.setState({ time });
    }, 1000);

    this.setState({ intervalID });
  }

  componentWillUnmount() {
    clearInterval(this.state.intervalID);
  }

  render() {
    return (
      <span className="text-warning bg-irinotes-headers">{ this.state.time }</span>
    );
  }
}

export default Clock
