import React from 'react';
import { shallow } from 'enzyme';
import NotesList from '../NotesList';

const setup = propOverrides => {
  const props = Object.assign({
      notes: [{
          _id: 'note1',
          text: 'test text 1'
        },
        {
          _id: 'note2',
          text: 'test text 2'
        },
        {
          _id: 'note3',
          text: 'test text 3'
        }]
  }, propOverrides);

  const wrapper = shallow(<NotesList {...props} />);

  return {
    props,
    wrapper,
  }
};

describe('Notes container Component', () => {
  test('render', () => {
    const { wrapper } = setup();
    expect(wrapper.exists()).toBe(true)
  });

  test('test note nb', () => {
    const { wrapper } = setup();
    expect(wrapper.find('Note').getElements()).toHaveLength(3);
  });

  test('test node key', () => {
    const { wrapper } = setup();
    wrapper.find('li').forEach((node, i) => {
      expect(node.key()).toBe('note'+(i+1));
    });
  });

  test('test node note', () => {
    const { wrapper } = setup();
    wrapper.find('Note').forEach((node, i) => {
      const {note} = node.props();
      expect(note._id).toBe('note'+(i+1));
      expect(note.text).toBe('test text '+(i+1));
    });
  });

});
