import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
// import logo from './logo.svg';
import { Navbar, Nav, NavItem, NavDropdown, MenuItem } from 'react-bootstrap';
import * as authActions from '../actions/authActions';

const LoginNav = ({isAuthenticated, currentUser, history, authActions}) => {

  const onClickSettings = (e) => {
    e.preventDefault();
    history.push('/settings');
  }

  const onClickLogout = (e) => {
    e.preventDefault();
    authActions.logout();
  }

  const onClickLogin = (e) => {
    e.preventDefault();
    history.push('/login');
  }


  if (isAuthenticated) {
    return (
      <NavDropdown title={ currentUser.get('username') } id="user-dropdown">
        <MenuItem onClick={onClickSettings}>Settings</MenuItem>
        <MenuItem onClick={onClickLogout}>Logout</MenuItem>
      </NavDropdown>
    );
  }
  return (
    <NavItem onClick={onClickLogin} href="/login">Login</NavItem>
  );
}

const Online = ({ offline }) => {
  return (
    <NavItem>
      <span className="material-icons" style={{ color: offline.online ? '#2ECC71' : '#E74C3C' }}>signal_wifi_4_bar</span>
    </NavItem>
  )
}

class AppNavbar extends Component {

  onClickHome = (e) => {
    e.preventDefault();
    this.props.history.push('/');
  }

  onClickSessions = (e) => {
    e.preventDefault();
    this.props.history.push('/sessions');
  }

  render() {
    return (
      <Navbar fluid inverse fixedTop>
        <Navbar.Header>
          <Navbar.Brand>
            <a onClick={this.onClickHome} href="/">IRI Notes</a>
          </Navbar.Brand>
          <Navbar.Toggle />
        </Navbar.Header>
        <Navbar.Collapse>
          <Nav>
            <NavItem onClick={this.onClickSessions} href="/sessions">Sessions</NavItem>
          </Nav>
          <Nav pullRight>
            <Online {...this.props} />
            <LoginNav {...this.props} />
          </Nav>
        </Navbar.Collapse>
      </Navbar>
    );
  }
}

AppNavbar.propTypes = {
  isAuthenticated: PropTypes.bool.isRequired
};

function mapStateToProps(state, props) {
  return {
    isAuthenticated: state['isAuthenticated'],
    currentUser: state['currentUser'],
    offline: state['offline']
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(AppNavbar);
