import { put, take, all, select } from 'redux-saga/effects'
import * as types from '../constants/actionTypes';
import { getLastSync } from './selectors';
import moment from 'moment';
import { endSynchronize, updateLastSync } from '../actions/syncActions';
import SessionSynchronizer from './SessionSyncronizer';
import NoteSynchronizer from './NoteSyncronizer';


function* watchSync(context) {
  while (true) {
    yield take(types.SYNC_DO_SYNC);
    const lastSync = yield select(getLastSync);


    //const sessions = yield context.client.get('/api/notes/sessions/', {modified_since: lastSync});
    const nextLastSync = moment().unix()

    // TODO: manage errors
    try {
      const syncObjects = yield context.client.get('/api/notes/sync/', { modified_since: lastSync });

      const sessionSynchronizer = new SessionSynchronizer(syncObjects.sessions, context.client);
      yield sessionSynchronizer.syncObjects();

      const noteSynchronizer = new NoteSynchronizer(syncObjects.notes, context.client);
      yield noteSynchronizer.syncObjects();

      yield put(updateLastSync(nextLastSync));
    } finally {
      yield put(endSynchronize());
    }
  }
}

//--- The root saga
export default function* rootSaga(context) {
  yield all([
    watchSync(context)
  ]);
}
