// Define state selector for saga
import Immutable from 'immutable';
import { ActionEnum } from '../constants'

export const getLastSync = state => state.getIn(['authStatus', 'lastSync']) || 0

export const getToken = state => state.getIn(['authStatus','token'])

const getSessionMapSelector = actionVal => state =>
  state.get('sessions')
    .filter(s => s.get('action') === actionVal)
    .reduce(
      (res, obj) => {
        return res.set(obj.get('_id'), obj);
      },
      Immutable.Map()
    );

const getNoteMapSelector = actionVal => state => {
  const deletedSessions = state.get('sessions')
    .filter(s => s.get('action') === ActionEnum.DELETED)
    .reduce(
      (res, obj) => {
        return res.set(obj.get('_id'), obj);
      },
      Immutable.Map()
    );
  return state.get('notes')
    .filter(n => (n.get('action') === actionVal && !deletedSessions.has(n.get('session'))))
    .reduce(
      (res, obj) => {
        return res.set(obj.get('_id'), obj);
      },
      Immutable.Map()
    );
}


export const getUpdatedSessions = getSessionMapSelector(ActionEnum.UPDATED);

export const getCreatedSessions = getSessionMapSelector(ActionEnum.CREATED);

export const getDeletedSessions = getSessionMapSelector(ActionEnum.DELETED);

export const getUpdatedNotes = getNoteMapSelector(ActionEnum.UPDATED);

export const getCreatedNotes = getNoteMapSelector(ActionEnum.CREATED);

export const getDeletedNotes = getNoteMapSelector(ActionEnum.DELETED);
