import { now } from '../utils';
import { ActionEnum } from '../constants'
import * as types from '../constants/actionTypes';


export const createSession = (sessionId) => {

  const newSession = {
      _id: sessionId,
      ext_id: sessionId,
      date: now(),
      title: '',
      description: '',
      action: ActionEnum.CREATED
  };

  return {
    type: types.CREATE_SESSION,
    session: newSession,
  };
}

export const updateSession = (session, values) => {
  return {
    type: types.UPDATE_SESSION,
    session: session,
    values: values,
  };
}

export const deleteSession = (session) => {
  return {
    type: types.DELETE_SESSION,
    session: session,
  };
}

export const doDeleteSession = (sessionId) => {
  return { type: types.DO_DELETE_SESSION, sessionId };
}

export const loadSessions = () => {
  return {
    type: types.LOAD_SESSIONS
  }
}

export const loadSession = (session) => {
  return { type: types.LOAD_SESSION, session };
}

export const resetActionSession = (session) => {
  return { type: types.RESET_ACTION_SESSION, session };
}

export const createGroupAndUpdateSession = (session, name) => {
  const group = {
    name
  };

  return {
    type: types.GROUP_CREATE_AND_UPDATE_ASYNC,
    session,
    group,
  };
}
