'''
Inspired by https://stackoverflow.com/a/36289332
'''
from django_filters.rest_framework import (BaseInFilter, Filter, FilterSet,
                                           UUIDFilter)

from ..models import Note, Session

class ExtIdFilter(BaseInFilter, UUIDFilter):
    pass

class CoreFilterSet(FilterSet):
    ext_id__in = ExtIdFilter(field_name='ext_id')

class SessionFilterSet(CoreFilterSet):
    class Meta:
        model = Session
        fields = ['ext_id__in']

class NoteFilterSet(CoreFilterSet):
    class Meta:
        model = Note
        fields = ['ext_id__in']

