import React from 'react';
import { shallow } from 'enzyme';
import Note from '../Note';

const setup = propOverrides => {
  const props = Object.assign({
      note: {
        _id: 'abc',
        session: 'foo',

        plain: 'test text',
        raw: {
          document: {
            nodes: [
              {
                object: 'block',
                type: 'paragraph',
                nodes: [
                  {
                    object: 'text',
                    leaves: [
                      {
                        text: 'test text',
                      },
                    ],
                  },
                ],
              },
            ],
          },
        },
        html: 'test text',
        startedAt: Date.now(),
        finishedAt: Date.now() + 60000,
      },
      isEditing: false
  }, propOverrides);

  const wrapper = shallow(<Note {...props} />);

  return {
    props,
    wrapper,
  }
}

describe('Notes container Component', () => {
  test('render', () => {
    const { wrapper } = setup()
    expect(wrapper.exists()).toBe(true)
  });

  test('contains note text', () => {
    const { wrapper } = setup();
    expect(wrapper.find('.note-content').render().text()).toBe('test text');
  });

  test('contains note id', () => {
    const { wrapper } = setup();
    expect(wrapper.first().prop('id')).toBe('note-abc');
  });


});
