import Immutable from 'immutable';
import { ActionEnum } from '../constants'


const getSessionMapSelector = actionVal => state =>
  state.get('sessions')
    .filter(s => s.get('action') === actionVal)
    .reduce(
      (res, obj) => {
        return res.set(obj.get('_id'), obj);
      },
      Immutable.Map()
    );

const getNoteMapSelector = actionVal => state => {
  const deletedSessions = state.get('sessions')
    .filter(s => s.get('action') === ActionEnum.DELETED)
    .reduce(
      (res, obj) => {
        return res.set(obj.get('_id'), obj);
      },
      Immutable.Map()
    );
  return state.get('notes')
    .filter(n => (n.get('action') === actionVal && !deletedSessions.has(n.get('session'))))
    .reduce(
      (res, obj) => {
        return res.set(obj.get('_id'), obj);
      },
      Immutable.Map()
    );
}


export const getUpdatedSessions = getSessionMapSelector(ActionEnum.UPDATED);

export const getCreatedSessions = getSessionMapSelector(ActionEnum.CREATED);

export const getDeletedSessions = getSessionMapSelector(ActionEnum.DELETED);

export const getUpdatedNotes = getNoteMapSelector(ActionEnum.UPDATED);

export const getCreatedNotes = getNoteMapSelector(ActionEnum.CREATED);

export const getDeletedNotes = getNoteMapSelector(ActionEnum.DELETED);

export const getActiveSessions = state => state.get('sessions').filter(session => session.get('action') !== ActionEnum.DELETED)

export const getSessions = state => state.get('sessions')
export const getNotes = state => state.get('notes')

export const getSession = (sessionId, state) => {
  const sessions = getSessions(state);
  return sessions.find(session => session._id === sessionId)
}

export const getSessionNotes = (sessionId, state) => {
  const notes = getNotes(state);
  return notes.filter(note => {
    return (note.get('session') === sessionId && note.get('action') !== ActionEnum.DELETED);
  }).sortBy( n => n.get('startedAt') );
}

