
import { autoSubmit, online } from '../miscReducer';
import * as types from '../../constants/actionTypes';


describe('misc reducer autosubmit', () => {

  it('should return the initial state', () => {
    expect(
      autoSubmit(undefined, {})
    ).toEqual(false)
  });

  it('should handle USER_TOGGLE_AUTO_SUBMIT true', () => {
    expect(
      autoSubmit(false, {
        type: types.USER_TOGGLE_AUTO_SUBMIT,
        value: true
      })
    ).toEqual(true)
  });

  it('should handle USER_TOGGLE_AUTO_SUBMIT false', () => {
    expect(
      autoSubmit(true, {
        type: types.USER_TOGGLE_AUTO_SUBMIT,
        value: false
      })
    ).toEqual(false)
  });

});



describe('misc reducer online', () => {

  it('should return the initial state', () => {
    expect(
      online(undefined, {})
    ).toEqual(false)
  });

  it('should handle STATUS_ONLINE', () => {
    expect(
      online(false, {
        type: types.STATUS_ONLINE
      })
    ).toEqual(true)
  });

  it('should handle STATUS_OFFLINE', () => {
    expect(
      online(true, {
        type: types.STATUS_OFFLINE
      })
    ).toEqual(false)
  });

});
