#!/usr/bin/env bash

set -e

function usage() {
    cat <<EOF
Usage: $0 "x.y.z"
    "x.y.z": version number, following the semver convention
EOF
}

if [ $# -ne 1 ]; then
    echo "Bad number of parameters"
    usage >&2
    exit 1
fi

if [[ "$1" == "-h" || "$1" == "--help" ]]; then
    usage
    exit 0
fi

version=$1

echo "Version: ${version}"

[[ "${version}" =~ ^[[:digit:]]+\.[[:digit:]]+\.[[:digit:]]+$ ]] || {
    echo "Bad format for version."
    usage >&2
    exit 1
}

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
green="\x1B[0;32m" # '\e[1;32m' is too bright for white bg.
blue="\x1B[1;34m"
endColor="\x1B[0m"

function echoblue() {
    echo -e "${blue}$1${endColor}"
}

pushd "$DIR"

pushd ../client
echoblue "Setting js client version"
yarn run set-version "$version"
popd

pushd ../src
echoblue "Setting server version"
python3 setup.py set_version --version="$version"
popd

echoblue "Version has been changed, please commit and push if necessary."


popd
