import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, Panel, FormGroup, ControlLabel, FormControl, Button, Alert, HelpBlock } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import * as authActions from '../actions/authActions';

class Login extends Component {

  state = {
    username: '',
    password: ''
  }

  handleInputChange = (e) => {
    const target = e.target;
    const value = target.value;
    const name = target.name;

    this.setState({
      [name]: value
    });
  }


  login = () => {
    const { username, password } = this.state;

    this.props.authActions.loginSubmit(username, password);
  }

  submit = (e) => {
    e.preventDefault();

    this.login();
  }

  onClickRegister = (e) => {
    e.preventDefault();
    this.props.history.push('/register');
  }

  renderErrorMessage(errorMessages, fieldname) {
    if (errorMessages && errorMessages.has(fieldname)) {
      return errorMessages.get(fieldname).map((message, key) =>
        <HelpBlock key={ key }>{ message }</HelpBlock>
      );
    }
  }

  renderNonFieldErrors(errorMessages) {
    if (errorMessages && errorMessages.has('non_field_errors')) {
      const errors = errorMessages.get('non_field_errors');
      return (
        <Alert bsStyle="danger">
        { errors.map((message, key) =>
          <p key={ key }>{ message }</p>
        ) }
        </Alert>
      )
    }
  }

  render() {

    const panelHeader = (
      <h4 className="text-uppercase text-center">Login</h4>
    )

    const errorMessages = this.props.login.get('errorMessages');

    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={6} mdOffset={3}>
              <Panel header={ panelHeader } className="panel-login">
                <form onSubmit={this.submit}>
                  <FormGroup validationState={ errorMessages && errorMessages.has('username') ? 'error' : null }>
                    <ControlLabel>Username</ControlLabel>
                    <FormControl componentClass="input" type="text" onChange={this.handleInputChange} name="username" />
                    { this.renderErrorMessage(errorMessages, 'username') }
                  </FormGroup>
                  <FormGroup validationState={ errorMessages && errorMessages.has('password') ? 'error' : null }>
                    <ControlLabel>Password</ControlLabel>
                    <FormControl componentClass="input" type="password" onChange={this.handleInputChange} name="password" />
                    { this.renderErrorMessage(errorMessages, 'password') }
                  </FormGroup>
                  { this.renderNonFieldErrors(errorMessages) }
                  <Button type="submit" block bsStyle="primary" onClick={this.login}>Login</Button>
                </form>
              </Panel>
              <p className="text-center">
                <a className="text-muted" href="/register" onClick={ this.onClickRegister }>Not registered yet? Create an account.</a>
              </p>
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    login: state.get('login')
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Login);
