'''
field serializing and deserializing metacategorization protocols
'''
import logging

from notes import settings
from rest_framework import serializers

logger = logging.getLogger(__name__)

class ProtocolField(serializers.Field):

    def get_attribute(self, obj):
        logger.debug("ProtocolField.get_attribute %r", obj)
        # We pass the object instance onto `to_representation`,
        # not just the field attribute.
        return obj

    def to_representation(self, obj):
        logger.debug("ProtocolField.to_representation %r", obj)
        return settings.NOTES_SETTINGS['PROTOCOL']

    def to_internal_value(self, data):
        logger.debug("ProtocolField.to_internal_value %r", data)
        return "base protocol"

