from ..models import ProtocolRevision, MetacategoryRevision

from rest_framework import serializers

class MetacategoryRevisionSerializer(serializers.ModelSerializer):
    id = serializers.UUIDField(read_only=True, source='ext_id')
    base = serializers.UUIDField(read_only=True, source='base.ext_id')
    class Meta:
        model = MetacategoryRevision
        fields = ['id', 'base', 'title', 'label', 'description', 'version', 'color', 'has_comment']

class ProtocolRevisionSerializer(serializers.ModelSerializer):
    id = serializers.UUIDField(read_only=True, source='protocol.ext_id')
    owner = serializers.CharField(read_only=True, source='protocol.owner')
    metacategories = MetacategoryRevisionSerializer(many=True, read_only=True)
    class Meta:
        model = ProtocolRevision
        fields = ['id', 'owner', 'title', 'description', 'version', 'metacategories']
