import React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { MemoryRouter } from 'react-router';
import { createMemoryHistory } from 'history'

import App from '../App';
import configureStore from '../store/configureStore';

beforeAll(() => {
  window.getSelection = () => {
    return {
      removeAllRanges: () => {}
    };
  };
});

const history = createMemoryHistory();
const { store } = configureStore(history);

it('renders without crashing', () => {
  const div = document.createElement('div');
  ReactDOM.render(
    <Provider store={store}>
      <MemoryRouter>
        <App />
      </MemoryRouter>
    </Provider>,
    div);
});
