'''
field serializing and deserializing metacategorization protocols
'''
import logging

from rest_framework import serializers

logger = logging.getLogger(__name__)

class ProtocolField(serializers.Field):

    def get_attribute(self, obj):
        logger.debug("ProtocolField.get_attribute %r", obj)
        # We pass the object instance onto `to_representation`,
        # not just the field attribute.
        return obj

    def to_representation(self, obj):
        logger.debug("ProtocolField.to_representation %r", obj)
        return {
            "id": "a4977c1f-4752-4aff-b724-eec4033af25c",
            "owner": "group1",
            "revision": "1",
            "description": "Cras rutrum lacinia pretium. Suspendisse justo est, tincidunt sed tellus a, sodales suscipit risus. Curabitur odio tortor, tincidunt sed est nec, ullamcorper sodales velit.",
            "metacategories": [{
                "id": "e5712a76-857a-4769-b27e-a3ac3fb38b4d",
                "revision": 2,
                "base": "ef14bcce-52ac-44ba-a7d1-f1441bab94de",
                "name": "référence",
                "description": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin massa nibh, hendrerit quis justo vitae, luctus tempor dolor. Nam quis fringilla diam.",
                "color": "#2cbfff",
                "has_comment": False
            }]
        }

    def to_internal_value(self, data):
        logger.debug("ProtocolField.to_internal_value %r", data)
        return "base protocol"

