import React, {Component} from 'react';

import { Form, FormGroup, Button } from 'react-bootstrap';

import PropTypes from 'prop-types';
import SlateEditor from './SlateEditor';

class NoteInput extends Component {
  constructor(props) {
    super(props);

    this.state = {value: ''};

    this.onAddNoteClick = this.onAddNoteClick.bind(this);
    this.handleChange = this.handleChange.bind(this);
  }

  handleChange(event) {
    this.setState({value : event.target.value});
  }

  onAddNoteClick(event) {
    //const text = this.refs.editor.asPlain();
    if(this.state.value && this.state.value.length > 0) {
      this.props.addNote(this.state.value);
      this.refs.editor.clear();
    }
  }

  render() {
    return (
      <Form>
        <FormGroup>
          <SlateEditor ref="editor" onChange={this.handleChange} />
        </FormGroup>
        <Button type="button" onClick={this.onAddNoteClick}>Add Note</Button>
      </Form>
    );
  }
}

NoteInput.propTypes = {
  addNote: PropTypes.func.isRequired
};

export default NoteInput;
