"""
auth module that defines irinotes' users and group
"""
from django.contrib.auth.models import AbstractUser, Group
from django.db import models
from django.utils.translation import ugettext_lazy as _


class User(AbstractUser):
    class Meta:
        verbose_name = _('User')
        verbose_name_plural = _('Users')


class UserProfile(models.Model):
    user = models.OneToOneField(User, on_delete=models.CASCADE)

    class Meta:
        verbose_name = _('UserProfile')
        verbose_name_plural = _('UserProfiles')


class GroupProfile(models.Model):
    group = models.OneToOneField(
        Group, unique=True, on_delete=models.CASCADE, related_name='profile')
    description = models.TextField(null=True, blank=True)
    # TODO: manage when user is deleted: put first user as owner. delete group if empty
    owner = models.ForeignKey(User, on_delete=models.SET_NULL, null=True)

    class Meta:
        verbose_name = _('GroupProfile')
        verbose_name_plural = _('GroupProfiles')
