import { now } from '../utils';
import * as types from '../constants/actionTypes';

export const createSession = (sessionId) => {

  const newSession = {
      _id: sessionId,
      ext_id: sessionId,
      date: now(),
      title: '',
      description: '',
      deleted: false,
      modified: true
  };

  return {
    type: types.CREATE_SESSION,
    session: newSession,
    meta: {
      offline: {
        effect: {
          url: `/api/notes/sessions/`,
          method: 'POST',
          data: newSession
        },
        commit: { type: types.NOOP },
        rollback: { type: types.NOOP }
      }
    }
  };
}

export const updateSession = (session, values) => {
  return {
    type: types.UPDATE_SESSION,
    session: session,
    values: values,
    meta: {
      offline: {
        effect: {
          url: `/api/notes/sessions/${session.get('_id')}/`,
          method: 'PUT',
          data: values
        },
        commit: { type: types.NOOP },
        rollback: { type: types.NOOP }
      }
    }
  };
}

export const deleteSession = (session) => {
  return {
    type: types.DELETE_SESSION,
    session: session,
    meta: {
      offline: {
        effect: {
          url: `/api/notes/sessions/${session.get('_id')}/`,
          method: 'DELETE',
        },
        commit: { type: types.NOOP },
        rollback: { type: types.NOOP }
      }
    }
  };
}

export const loadSessions = () => {
  return {
    type: types.LOAD_SESSIONS
  }
}

export const createGroupAndUpdateSession = (session, name) => {
  const group = {
    name
  };

  return {
    type: types.GROUP_CREATE_AND_UPDATE_ASYNC,
    session,
    group,
  };
}
