import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Form, FormControl } from 'react-bootstrap';

import PropTypes from 'prop-types';
import SlateEditor from './SlateEditor';
import * as notesActions from '../actions/notesActions';
import * as userActions from '../actions/userActions';
import { now } from '../utils';


class NoteInput extends Component {

  state = {
    buttonDisabled: false,
    startedAt: null,
    finishedAt: null,
  }

  onEditorChange = (e) => {
    this.setState({
      buttonDisabled: e.state.document.length === 0,
      startedAt: e.startedAt,
      finishedAt: e.finishedAt
    });
  }

  onAddNoteClick = () => {

    const plain = this.refs.editor.asPlain();
    const raw = this.refs.editor.asRaw();
    const html = this.refs.editor.asHtml();
    const categories = this.refs.editor.asCategories();
    const marginComment = this.marginComment.value;

    this.props.notesActions.addNote(this.props.session, {
      plain: plain,
      raw: raw,
      html: html,
      startedAt: this.state.startedAt,
      finishedAt: now(),
      categories: categories,
      marginComment: marginComment,
    });

    this.refs.editor.clear();
    setTimeout(() => this.refs.editor.focus(), 250);
  }

  onCheckboxChange = (e) => {
    this.props.userActions.setAutoSubmit(e.target.checked);
  }

  componentDidMount() {
    const text = this.refs.editor.asPlain();
    this.setState({ buttonDisabled: text.length === 0 });
  }

  render() {
    return (
      <Form>
        <div className="editor">
          <div className="editor-left">
            <SlateEditor ref="editor"
              onChange={this.onEditorChange}
              onEnterKeyDown={this.onAddNoteClick}
              onButtonClick={this.onAddNoteClick}
              onCheckboxChange={this.onCheckboxChange}
              isChecked={this.props.autoSubmit}
              isButtonDisabled={this.state.buttonDisabled} />
          </div>
          <div className="editor-right">
            <FormControl
              name="margin"
              componentClass="textarea"
              placeholder="Enter a margin comment for your note"
              inputRef={ ref => { this.marginComment = ref; } }
            />
          </div>
        </div>
      </Form>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    autoSubmit: state.autoSubmit
  };
}

function mapDispatchToProps(dispatch) {
  return {
    notesActions: bindActionCreators(notesActions, dispatch),
    userActions: bindActionCreators(userActions, dispatch),
  }
}

NoteInput.propTypes = {
  addNote: PropTypes.func.isRequired
};

export default connect(mapStateToProps, mapDispatchToProps)(NoteInput);
