// Selectors linked to the authentication status

export const getOnline = state => state.getIn(["status", 'online'])

export const getToken = state => state.getIn(['authStatus','token'])

export const isAuthenticated = state => state.getIn(['authStatus', 'isAuthenticated'])

export const getCurrentUser = state => state.getIn(['authStatus', 'currentUser'])

export const getClientId = state => state.getIn(['authStatus', 'clientId'])

export const getCurrentGroupName = state => state.getIn(['authStatus', 'currentGroup'])

export const getGroups = state => state.get('groups')

export const getCurrentGroup = state => {
  const groupName = getCurrentGroupName(state);
  const groups = getGroups(state);
  if(groups) {
    return groups.find( g => g.get('name') === groupName );
  } else {
    return null;
  }
}

export const getCreateGroup = state => state.get('createGroup')



