import React from 'react';
import { ListGroup, ListGroupItem } from 'react-bootstrap';
import _ from 'lodash';
import '../App.css';
import {formatTimestamp} from '../utils';

const SessionSummary = ({notes}) => (
  <ListGroup>
    {notes.map((note) =>
      <ListGroupItem key={note.get('_id')}>
        <a href={'#note-' + note.get('_id')}>
          <span className="text-muted">{formatTimestamp(note.startedAt)} → {formatTimestamp(note.finishedAt)}</span>
          <span className="pull-right">{_.words(note.plain).length} words</span>
        </a>
      </ListGroupItem>
    )}
  </ListGroup>
)

export default SessionSummary;
