import React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { Route } from 'react-router';
import { ConnectedRouter } from 'react-router-redux';
import createHistory from 'history/createBrowserHistory';

import App from './App';
import SessionList from './components/SessionList';
import Session from './components/Session';
import Login from './components/Login';
import Register from './components/Register';
import Settings from './components/Settings';
import './index.css';
import registerServiceWorker from './registerServiceWorker';
import configureStore from './store/configureStore';
import config from './config';

const history = createHistory({
    basename: config.basename
});
const store = configureStore(history);

ReactDOM.render(
  <Provider store={store}>
    <ConnectedRouter history={history}>
      <div>
        <Route exact path="/settings" component={Settings} />
        <Route exact path="/sessions/:id" component={Session} />
        <Route exact path="/sessions" component={SessionList} />
        <Route exact path="/register" component={Register} />
        <Route exact path="/login" component={Login} />
        <Route exact path="/" component={App} />
      </div>
    </ConnectedRouter>
  </Provider>,
  document.getElementById('root')
);
registerServiceWorker();
