import Immutable from 'immutable';
import * as types from '../constants/actionTypes';
import SessionRecord from '../store/sessionRecord';

export const sessions = (state = Immutable.List([]), action) => {
  let sessionIndex;

  switch (action.type) {
    case types.CREATE_SESSION:
      return state.push(new SessionRecord(action.session));
    case types.UPDATE_SESSION:
      const sessionToUpdate = state.find(session => session === action.session);
      sessionIndex = state.indexOf(action.session);
      if (sessionIndex === -1) {
        return state;
      }
      const updatedSession = sessionToUpdate.merge(action.values);
      return state.set(sessionIndex, updatedSession);
    case types.DELETE_SESSION:
      sessionIndex = state.indexOf(action.session);
      if (sessionIndex === -1) {
        return state;
      }
      return state.delete(sessionIndex);
    case types.LOAD_SESSIONS:
      return action.sessions;
    default:
      return state;
  }
};
