import React, { Component } from 'react';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';

import PropTypes from 'prop-types';
import Immutable from 'immutable';

import { Grid, Row, Col} from 'react-bootstrap';

import * as notesActions from '../actions/notes-actions';
import NotesList from './NotesList';
import NoteInput from './NoteInput';

class NotesContainer extends Component {
    render() {
        const { notes } = this.props;
        return (
          <Grid>
            <Row>
              <Col xs={12} md={12}>
                <NotesList notes={notes} />
              </Col>
            </Row>
            <Row>
              <Col xs={12} md={12}>
                <NoteInput addNote={this.props.actions.addNote} />
              </Col>
            </Row>
          </Grid>
        );
    }
}

NotesContainer.propTypes = {
    notes: PropTypes.instanceOf(Immutable.List).isRequired,
    actions: PropTypes.object.isRequired
}

function mapStateToProps(state, props) {
  return {
    notes: state.get('notes')
  };
}

function mapDispatchToProps(dispatch) {
  return {
    actions: bindActionCreators(notesActions, dispatch)
  }
}


export default connect(mapStateToProps, mapDispatchToProps)(NotesContainer);