import uuidV1 from 'uuid/v1';

import * as types from '../constants/actionTypes';

export const addNote = (session, data) => {
  const noteId = uuidV1();
  const note = {
    _id: noteId,
    session: session._id,
    raw: data.raw,
    plain: data.plain,
    html: data.html,
    startedAt: data.startedAt,
    finishedAt: data.finishedAt,
    categories: data.categories,
    marginComment: data.marginComment,
  };

  const noteSrvr = {
    ext_id: noteId,
    session: session._id,
    raw: JSON.stringify(data.raw),
    plain: data.plain,
    html: data.html,
    tc_start: data.startedAt,
    tc_end: data.finishedAt,
    categorization: JSON.stringify(data.categories),
  }

  return {
    type: types.ADD_NOTE,
    note,
    meta: {
      offline: {
        effect: {
          url: `/api/notes/sessions/${session.get('_id')}/notes/`,
          method: 'POST',
          data: noteSrvr
        },
        commit: { type: types.NOOP },
        rollback: { type: types.NOOP }
      }
    }
  };
}

export const deleteNote = (note) => {
  return {
    type: types.DELETE_NOTE,
    note
  };
}

export const updateNote = (note, data) => {
  return {
    type: types.UPDATE_NOTE,
    note,
    data
  };
}
