import React, { Component } from 'react';
import { connect } from 'react-redux';
import { ListGroup, ListGroupItem } from 'react-bootstrap';
import _ from 'lodash';
import '../App.css';
import {formatTimestamp} from '../utils';

class SessionSummary extends Component {
  render() {
    return (
      <ListGroup>
        {this.props.notes.map((note) =>
          <ListGroupItem key={note.get('_id')}>
            <a href={'#note-' + note.get('_id')}>
              <span className="text-muted">{formatTimestamp(note.startedAt)} → {formatTimestamp(note.finishedAt)}</span>
              <span className="pull-right">{_.words(note.plain).length} words</span>
            </a>
          </ListGroupItem>
        )}
      </ListGroup>
    );
  }
}

function mapStateToProps(state, props) {
  return props;
}

export default connect(mapStateToProps)(SessionSummary);
