import uuidV1 from 'uuid/v1';

import * as types from '../constants/actionTypes';

export const addNote = (session, data) => {
  return {
    type: types.ADD_NOTE,
    note: {
      _id: uuidV1(),
      session: session._id,
      raw: data.raw,
      plain: data.plain,
      html: data.html,
      startedAt: data.startedAt,
      finishedAt: data.finishedAt,
      categories: data.categories,
    }
  };
}

export const loadNotesBySession = (session) => {
  return {
    type: types.LOAD_NOTES_BY_SESSION,
    session: session
  }
}
