import React from 'react';

import PropTypes from 'prop-types';
import Immutable from 'immutable';

import { Alert } from 'react-bootstrap';

import Note from './Note';

const NotesList = ({notes}) => {

  if (notes.size === 0) {
    return (
      <Alert bsStyle="warning">No notes yet. Add notes with the textarea below.</Alert>
    );
  }

  return (
    <div>
      {notes.map((note) =>
        <Note note={note} key={note._id} />
      )}
    </div>
  );
};

NotesList.propTypes = {
  notes: PropTypes.instanceOf(Immutable.List).isRequired
};

export default NotesList;
