"""
auth module that defines irinotes' users and group
"""
from django.contrib.auth.models import AbstractUser, Group
from django.db import models
from django.utils.translation import ugettext_lazy as _


class User(AbstractUser):

    class Meta:
        verbose_name = _('User')
        verbose_name_plural = _('Users')


class UserProfile(models.Model):
    user = models.OneToOneField(User, on_delete=models.CASCADE, related_name='profile')

    # TODO:
    default_group = models.ForeignKey(
        Group,
        null=False,
        verbose_name=_("UserProfile|default_group"))

    class Meta:
        verbose_name = _('UserProfile')
        verbose_name_plural = _('UserProfiles')


class GroupProfile(models.Model):
    group = models.OneToOneField(
        Group, unique=True, on_delete=models.CASCADE, related_name='profile')
    description = models.TextField(null=True, blank=True)
    # TODO: manage when user is deleted: put first user as owner. delete group if empty
    owner = models.ForeignKey(User, on_delete=models.SET_NULL, null=True)
    # TODO: can not delete group when user is not deleted.
    # TODO: other users cannot set as owner
    # TODO: delete personal group when user is deleted
    # TODO: change group name when user change name
    # indicate that this group is a personal group.
    # used this instead of a boolean because it allows to easily enforce that a user has only one personal group
    owner_personal = models.OneToOneField(User, on_delete=models.CASCADE, null=True, related_name='personal_group')

    @property
    def is_personal(self):
        return self.owner == self.owner_personal

    class Meta:
        verbose_name = _('GroupProfile')
        verbose_name_plural = _('GroupProfiles')
